/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms.test;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;

public class DebugSQLServerConnection {
    private Connection con = null;
    private final String url = "jdbc:sqlserver://";
    private final String serverName = "localhost";
    private final String portNumber = "1433";
    private final String databaseName = "melatijunit";
    private final String userName = "sa";
    private final String password = "";

    private String getConnectionUrl() {
        return "jdbc:sqlserver://localhost:1433;databaseName=melatijunit;selectMethod=cursor;";
    }

    private Connection getConnection() {
        try {
            Class<?> driverClass = Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            if (driverClass == null) {
                throw new RuntimeException("No class found");
            }
            Driver driver = (Driver)driverClass.newInstance();
            DriverManager.setLogWriter(new PrintWriter(System.out));
            DriverManager.registerDriver(driver);
            this.con = DriverManager.getConnection(this.getConnectionUrl(), "sa", "");
            if (this.con != null) {
                System.out.println("Connection Successful!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error Trace in getConnection() : " + e.getMessage());
        }
        return this.con;
    }

    public void displayDbProperties() {
        DatabaseMetaData dm = null;
        ResultSet rs = null;
        try {
            this.con = this.getConnection();
            if (this.con != null) {
                dm = this.con.getMetaData();
                System.out.println("Driver Information");
                System.out.println("\tDriver Name: " + dm.getDriverName());
                System.out.println("\tDriver Version: " + dm.getDriverVersion());
                System.out.println("\nDatabase Information ");
                System.out.println("\tDatabase Name: " + dm.getDatabaseProductName());
                System.out.println("\tDatabase Version: " + dm.getDatabaseProductVersion());
                System.out.println("Avalilable Catalogs ");
                rs = dm.getCatalogs();
                while (rs.next()) {
                    System.out.println("\tcatalog: " + rs.getString(1));
                }
                rs.close();
                rs = null;
                this.closeConnection();
            } else {
                System.out.println("Error: No active Connection");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dm = null;
    }

    private void closeConnection() {
        try {
            if (this.con != null) {
                this.con.close();
            }
            this.con = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        DebugSQLServerConnection myDbTest = new DebugSQLServerConnection();
        myDbTest.displayDbProperties();
    }
}

