/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.melati.poem.Persistent;
import org.melati.poem.Table;
import org.melati.poem.csv.CSVColumn;
import org.melati.poem.csv.CSVField;
import org.melati.poem.csv.CSVFileParser;
import org.melati.poem.csv.CSVParseException;
import org.melati.poem.csv.CSVPrimaryKeyColumnAlreadySetException;
import org.melati.poem.csv.CSVRecord;
import org.melati.poem.csv.CSVWriteDownException;
import org.melati.poem.csv.NoPrimaryKeyInCSVTableException;

public class CSVTable {
    protected Table table = null;
    protected File data = null;
    protected Hashtable columns = new Hashtable();
    protected Vector columnsInUploadOrder = new Vector();
    protected CSVColumn primaryKey = null;
    protected Vector records = new Vector();
    protected BufferedReader reader = null;
    protected CSVFileParser parser = null;
    private int lineNo;
    private int recordNo;

    public CSVTable(Table table, File data) {
        this.table = table;
        this.data = data;
        try {
            this.reader = new BufferedReader(new FileReader(this.data));
            this.parser = new CSVFileParser(this.reader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void define() throws IOException {
        this.parser.nextRecord();
        this.lineNo = 1;
        this.recordNo = 0;
        while (this.parser.recordHasMoreFields()) {
            String key = this.parser.nextField();
            Object col = this.columns.get(key);
            if (col == null) {
                throw new CSVParseException("I don't know what to do with the column in " + this.data.getPath() + " called " + key);
            }
            this.columnsInUploadOrder.addElement(col);
        }
    }

    public void addColumn(String csvName, String poemName) {
        this.columns.put(csvName, new CSVColumn(poemName));
    }

    public void addColumn(String csvName, String poemName, boolean isPrimaryKey) throws CSVPrimaryKeyColumnAlreadySetException {
        if (isPrimaryKey && this.primaryKey != null) {
            throw new CSVPrimaryKeyColumnAlreadySetException(this.table.getName());
        }
        CSVColumn col = new CSVColumn(poemName, isPrimaryKey);
        this.columns.put(csvName, col);
        if (isPrimaryKey) {
            this.primaryKey = col;
        }
    }

    public void addColumn(String csvName, String foreignPoemName, CSVTable foreignTable) {
        this.columns.put(csvName, new CSVColumn(foreignPoemName, foreignTable));
    }

    public void load(boolean writeOnFly) throws IOException, CSVParseException, NoPrimaryKeyInCSVTableException, CSVWriteDownException {
        try {
            CSVRecord record;
            this.define();
            while (null != (record = this.parseRecord())) {
                record.setLineNo(this.lineNo++);
                record.setRecordNo(this.recordNo++);
                if (writeOnFly) {
                    record.makePersistent();
                    continue;
                }
                this.records.addElement(record);
            }
        }
        catch (IllegalArgumentException e) {
            throw new CSVParseException("Failed to load field in " + this.data.getPath() + " line " + this.lineNo + ": " + e.toString());
        }
        catch (NoSuchElementException f) {
            throw new CSVParseException("Failed to read column header in " + this.data.getPath() + " line " + this.lineNo + ": " + f.toString());
        }
        finally {
            this.reader.close();
        }
    }

    public CSVRecord parseRecord() throws IOException, CSVParseException {
        int i;
        if (!this.parser.nextRecord()) {
            return null;
        }
        String value = null;
        try {
            CSVRecord record = new CSVRecord(this.table);
            for (i = 0; i < this.columnsInUploadOrder.size(); ++i) {
                value = this.parser.nextField();
                CSVColumn col = (CSVColumn)this.columnsInUploadOrder.elementAt(i);
                record.addField(new CSVField(col, value));
            }
            record.setLineNo(this.parser.getLineNo());
            return record;
        }
        catch (IllegalArgumentException e) {
            throw new CSVParseException("Failed to read data field no. " + (i + 1) + " in " + this.data + " line " + this.lineNo + ": " + e.toString());
        }
        catch (NoSuchElementException f) {
            String message = "Problem with data field no. " + (i + 1) + " of " + this.columnsInUploadOrder.size() + " in " + this.data + " line " + this.lineNo;
            message = value == null ? message + " (Check last line of file) : " + f.toString() : message + ", Value:" + value + ": " + f.toString();
            throw new CSVParseException(message);
        }
    }

    public void emptyTable() {
        Enumeration rows = this.table.selection();
        while (rows.hasMoreElements()) {
            Persistent p = (Persistent)rows.nextElement();
            p.delete();
        }
    }

    public void writeRecords() throws NoPrimaryKeyInCSVTableException, CSVWriteDownException {
        for (int i = 0; i < this.records.size(); ++i) {
            ((CSVRecord)this.records.elementAt(i)).makePersistent();
        }
    }

    protected Persistent getRecordWithID(String csvValue) throws NoPrimaryKeyInCSVTableException, CSVWriteDownException {
        if (this.primaryKey == null) {
            throw new NoPrimaryKeyInCSVTableException(this.table.getName(), csvValue);
        }
        for (int i = 0; i < this.records.size(); ++i) {
            CSVRecord record = (CSVRecord)this.records.elementAt(i);
            if (record.primaryKeyValue == null || !record.primaryKeyValue.equals(csvValue)) continue;
            return record.getPersistent();
        }
        return null;
    }

    public void report(boolean recordDetails, boolean fieldDetails, Writer output) throws IOException {
        output.write("*** TABLE: " + this.table.getName().toUpperCase() + " **\n\n");
        output.write("** I have read " + this.records.size() + " records of " + this.columnsInUploadOrder.size() + " fields\n");
        if (recordDetails) {
            for (int i = 0; i < this.records.size(); ++i) {
                CSVRecord record = (CSVRecord)this.records.elementAt(i);
                output.write("   Record: CSV primary key = " + record.primaryKeyValue);
                if (record.poemRecord == null) {
                    output.write(", No Poem Persistent written\n");
                } else {
                    output.write(", Poem Troid = " + record.poemRecord.getTroid() + "\n");
                }
                if (!fieldDetails) continue;
                for (int j = 0; j < record.getFields().size(); ++j) {
                    CSVField field = (CSVField)record.getFields().elementAt(j);
                    output.write(field.column + "=\"" + field.value);
                    if (j < record.getFields().size() - 1) {
                        output.write("\",");
                        continue;
                    }
                    output.write("\"\n");
                }
            }
        }
        output.write("** Currently " + this.table.count(null) + " Persistents in this table\n\n");
    }

    public String getName() {
        return this.table.getName();
    }
}

