/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;

public class CSVFileParser {
    private BufferedReader reader = null;
    int lineNo = 0;
    private String line = "";
    private boolean emptyLastField = false;
    int p = 0;

    public CSVFileParser(BufferedReader reader) {
        this.reader = reader;
    }

    public boolean nextRecord() throws IOException {
        return this.nextLine();
    }

    private boolean nextLine() throws IOException {
        if (!this.reader.ready()) {
            return false;
        }
        this.line = this.reader.readLine();
        this.emptyLastField = false;
        this.p = 0;
        if (this.line == null) {
            this.reader.close();
            return false;
        }
        ++this.lineNo;
        return true;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public boolean recordHasMoreFields() {
        return this.emptyLastField || this.p < this.line.length();
    }

    public String nextField() throws IOException {
        return this.nextToken(false);
    }

    private String nextToken(boolean inUnclosedQuotes) throws IOException {
        if (this.emptyLastField) {
            this.emptyLastField = false;
            return "";
        }
        if (this.p >= this.line.length()) {
            throw new NoSuchElementException();
        }
        if (inUnclosedQuotes || this.line.charAt(this.p) == '\"' && ++this.p > 0) {
            int q = this.line.indexOf("\",", this.p);
            if (q == -1 && this.line.indexOf(34, this.p) == this.line.length() - 1) {
                q = this.line.length() - 1;
            }
            if (q == -1) {
                String sofar = this.line.substring(this.p, this.line.length());
                if (!this.nextLine()) {
                    throw new IllegalArgumentException("Unclosed quotes on line " + this.lineNo);
                }
                return sofar + "\n" + this.nextToken(true);
            }
            String it = this.line.substring(this.p, q);
            this.p = ++q + 1;
            if (q < this.line.length()) {
                if (this.line.charAt(q) != ',') {
                    this.p = this.line.length();
                    throw new IllegalArgumentException("No comma after quotes on line " + this.lineNo);
                }
                if (q == this.line.length() - 1) {
                    this.emptyLastField = true;
                }
            }
            return it;
        }
        int q = this.line.indexOf(44, this.p);
        if (q == -1) {
            String it = this.line.substring(this.p);
            this.p = this.line.length();
            return it;
        }
        String it = this.line.substring(this.p, q);
        if (q == this.line.length() - 1) {
            this.emptyLastField = true;
        }
        this.p = q + 1;
        return it;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("***** Reading file " + args[0]);
        BufferedReader reader = new BufferedReader(new FileReader(new File(args[0])));
        CSVFileParser toks = new CSVFileParser(reader);
        int recordCount = 0;
        while (toks.nextRecord()) {
            System.out.println("*** Record " + ++recordCount);
            int i = 0;
            while (toks.recordHasMoreFields()) {
                System.out.println("Field " + ++i + ":" + toks.nextField());
            }
        }
    }
}

