/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.melati.poem.AccessToken;
import org.melati.poem.AlreadyInSessionPoemException;
import org.melati.poem.Capability;
import org.melati.poem.CapabilityTable;
import org.melati.poem.Column;
import org.melati.poem.ColumnInfoTable;
import org.melati.poem.DefinitionSource;
import org.melati.poem.DuplicateTableNamePoemException;
import org.melati.poem.ExecutingSQLPoemException;
import org.melati.poem.ExtraColumn;
import org.melati.poem.GroupCapabilityTable;
import org.melati.poem.GroupMembershipTable;
import org.melati.poem.GroupTable;
import org.melati.poem.InterruptedPoemException;
import org.melati.poem.JdbcTable;
import org.melati.poem.NoMoreTransactionsException;
import org.melati.poem.NoSuchTablePoemException;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.PoemLogEvent;
import org.melati.poem.PoemTask;
import org.melati.poem.PoemThread;
import org.melati.poem.PoemTransaction;
import org.melati.poem.ReconnectionPoemException;
import org.melati.poem.SQLLogEvent;
import org.melati.poem.SQLPoemException;
import org.melati.poem.SQLPoemType;
import org.melati.poem.SQLSeriousPoemException;
import org.melati.poem.SessionToken;
import org.melati.poem.SettingTable;
import org.melati.poem.Table;
import org.melati.poem.TableCategoryTable;
import org.melati.poem.TableInUsePoemException;
import org.melati.poem.TableInfo;
import org.melati.poem.TableInfoTable;
import org.melati.poem.TroidPoemType;
import org.melati.poem.UnexpectedExceptionPoemException;
import org.melati.poem.UnificationPoemException;
import org.melati.poem.User;
import org.melati.poem.UserTable;
import org.melati.poem.dbms.Dbms;
import org.melati.poem.dbms.DbmsFactory;
import org.melati.poem.transaction.Transaction;
import org.melati.poem.transaction.TransactionPool;
import org.melati.poem.util.ArrayEnumeration;
import org.melati.poem.util.ArrayUtils;
import org.melati.poem.util.FlattenedEnumeration;
import org.melati.poem.util.MappedEnumeration;
import org.melati.poem.util.StringUtils;

public abstract class Database
implements TransactionPool {
    final Database _this = this;
    private Vector transactions = null;
    private Vector freeTransactions = null;
    private Connection committedConnection;
    private final ReadWriteLock lock = new WriterPreferenceReadWriteLock();
    private long structureSerial = 0L;
    private Vector tables = new Vector();
    private Hashtable tablesByName = new Hashtable();
    private Table[] displayTables = null;
    private String name;
    private String displayName;
    private Dbms dbms;
    private boolean logSQL = false;
    private boolean logCommits = false;
    private int transactionsMax;
    private String connectionUrl;
    private int queryCount = 0;
    private String lastQuery = null;
    private boolean initialised = false;
    private final boolean[] connecting = new boolean[1];
    private User guest = null;
    private User administrator = null;
    private UserCapabilityCache capabilityCache = new UserCapabilityCache();
    private Capability canAdminister = null;

    private synchronized void init() {
        if (!this.initialised) {
            Enumeration t = this.tables.elements();
            while (t.hasMoreElements()) {
                ((Table)t.nextElement()).init();
            }
            this.initialised = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String name, String dbmsclass, String url, String username, String password, int transactionsMaxP) throws PoemException {
        this.name = name;
        this.connectionUrl = url;
        boolean[] blArray = this.connecting;
        synchronized (this.connecting) {
            if (this.connecting[0]) {
                throw new ConnectingException();
            }
            this.connecting[0] = true;
            // ** MonitorExit[var7_7] (shouldn't be in output)
            try {
                this.setDbms(DbmsFactory.getDbms(dbmsclass));
                if (this.committedConnection != null) {
                    throw new ReconnectionPoemException(this);
                }
                this.setTransactionsMax(transactionsMaxP);
                this.committedConnection = this.getDbms().getConnection(url, username, password);
                this.transactions = new Vector();
                for (int s = 0; s < this.transactionsMax(); ++s) {
                    this.transactions.add(new PoemTransaction(this, this.getDbms().getConnection(url, username, password), s));
                }
                this.freeTransactions = (Vector)this.transactions.clone();
                try {
                    this.init();
                    DatabaseMetaData m = this.committedConnection.getMetaData();
                    this.getTableInfoTable().unifyWithDB(m.getColumns(null, this.dbms.getSchema(), this.dbms.unreservedName(this.getTableInfoTable().getName()), null));
                    this.getColumnInfoTable().unifyWithDB(m.getColumns(null, this.dbms.getSchema(), this.dbms.unreservedName(this.getColumnInfoTable().getName()), null));
                    this.getTableCategoryTable().unifyWithDB(m.getColumns(null, this.dbms.getSchema(), this.dbms.unreservedName(this.getTableCategoryTable().getName()), null));
                    this.inSession(AccessToken.root, new PoemTask(){

                        public void run() throws PoemException {
                            try {
                                Database.this._this.unifyWithDB();
                            }
                            catch (SQLException e) {
                                throw new SQLPoemException(e);
                            }
                        }

                        public String toString() {
                            return "Unifying with DB";
                        }
                    });
                }
                catch (SQLException e) {
                    if (this.committedConnection != null) {
                        this.disconnect();
                    }
                    throw new UnificationPoemException(e);
                }
            }
            catch (SQLPoemException e) {
                if (this.committedConnection != null) {
                    this.disconnect();
                }
                throw e;
            }
            finally {
                boolean[] blArray2 = this.connecting;
                synchronized (this.connecting) {
                    this.connecting[0] = false;
                    // ** MonitorExit[var11_15] (shouldn't be in output)
                }
            }
            return;
        }
    }

    public void disconnect() throws PoemException {
        if (this.committedConnection == null) {
            throw new ReconnectionPoemException(this);
        }
        try {
            Enumeration iter = this.freeTransactions.elements();
            while (iter.hasMoreElements()) {
                PoemTransaction txn = (PoemTransaction)iter.nextElement();
                txn.getConnection().close();
            }
            this.freeTransactions.removeAllElements();
            this.getDbms().shutdown(this.committedConnection);
            this.committedConnection.close();
        }
        catch (SQLException e) {
            throw new SQLPoemException(e);
        }
        this.committedConnection = null;
    }

    protected synchronized void defineTable(Table table) throws DuplicateTableNamePoemException {
        if (this.getTableIgnoringCase(table.getName()) != null) {
            throw new DuplicateTableNamePoemException(this, table.getName());
        }
        this.redefineTable(table);
    }

    protected synchronized void redefineTable(Table table) {
        if (table.getDatabase() != this) {
            throw new TableInUsePoemException(this, table);
        }
        if (this.getTableIgnoringCase(table.getName()) == null) {
            this.tablesByName.put(table.getName().toLowerCase(), table);
            this.tables.addElement(table);
        } else {
            this.tables.setElementAt(table, this.tables.indexOf(this.tablesByName.put(table.getName().toLowerCase(), table)));
        }
        this.displayTables = null;
    }

    private ResultSet columnsMetadata(DatabaseMetaData m, String tableName) throws SQLException {
        return m.getColumns(null, this.dbms.getSchema(), this.dbms.unreservedName(tableName), null);
    }

    public Table addTableAndCommit(TableInfo info, String troidName) throws PoemException {
        JdbcTable table = new JdbcTable(this, info.getName(), DefinitionSource.infoTables);
        table.defineColumn(new ExtraColumn(table, troidName, TroidPoemType.it, DefinitionSource.infoTables, table.getNextExtrasIndex()));
        table.setTableInfo(info);
        table.unifyWithColumnInfo();
        table.unifyWithDB(null);
        PoemThread.commit();
        this.defineTable(table);
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTableAndCommit(TableInfo info) {
        this.beginStructuralModification();
        try {
            Table table = info.actualTable();
            info.delete();
            table.dbModifyStructure(" DROP TABLE " + table.quotedName());
            Vector vector = this.tables;
            synchronized (vector) {
                this.tables.remove(table);
                this.tablesByName.remove(table.getName().toLowerCase());
                this.displayTables = (Table[])ArrayUtils.removed(this.displayTables, table);
                this.uncache();
                table.invalidateTransactionStuffs();
            }
            PoemThread.commit();
        }
        finally {
            this.endStructuralModification();
        }
    }

    private synchronized void unifyWithDB() throws PoemException, SQLException {
        Table table;
        boolean debug = true;
        Enumeration ti = this.getTableInfoTable().selection();
        while (ti.hasMoreElements()) {
            TableInfo tableInfo = (TableInfo)ti.nextElement();
            Table table2 = this.getTableIgnoringCase(tableInfo.getName());
            if (table2 == null) {
                if (debug) {
                    this.log("Defining table:" + tableInfo.getName());
                }
                table2 = new JdbcTable(this, tableInfo.getName(), DefinitionSource.infoTables);
                this.defineTable(table2);
            }
            table2.setTableInfo(tableInfo);
        }
        Enumeration t = this.tables.elements();
        while (t.hasMoreElements()) {
            ((Table)t.nextElement()).createTableInfo();
        }
        t = this.tables.elements();
        while (t.hasMoreElements()) {
            ((Table)t.nextElement()).unifyWithColumnInfo();
        }
        String[] normalTables = new String[]{"TABLE"};
        DatabaseMetaData m = this.committedConnection.getMetaData();
        ResultSet tableDescs = m.getTables(null, this.dbms.getSchema(), null, normalTables);
        while (tableDescs.next()) {
            if (debug) {
                this.log("Table:" + tableDescs.getString("TABLE_NAME") + " Type:" + tableDescs.getString("TABLE_TYPE"));
            }
            String tableName = this.dbms.melatiName(tableDescs.getString("TABLE_NAME"));
            if (debug) {
                this.log("Melati Table name :" + tableName);
            }
            table = null;
            if (tableName != null) {
                table = this.getTableIgnoringCase(tableName);
                if (table == null) {
                    ResultSet idCol;
                    if (debug) {
                        this.log("Unknown to POEM, with JDBC name " + tableName);
                    }
                    if ((idCol = m.getColumns(null, this.dbms.getSchema(), this.dbms.unreservedName(tableName), this.dbms.getJdbcMetadataName(this.dbms.unreservedName("id")))).next()) {
                        if (debug) {
                            this.log("Got an ID column for discovered jdbc table ");
                        }
                        if (this.dbms.canRepresent(this.defaultPoemTypeOfColumnMetaData(idCol), TroidPoemType.it) != null) {
                            try {
                                table = new JdbcTable(this, tableName, DefinitionSource.sqlMetaData);
                                this.defineTable(table);
                            }
                            catch (DuplicateTableNamePoemException e) {
                                throw new UnexpectedExceptionPoemException(e);
                            }
                            table.createTableInfo();
                        } else if (debug) {
                            this.log("Can represent failed");
                        }
                    } else if (debug) {
                        this.log("Table " + this.dbms.unreservedName(tableName) + " appears not to have a troid column called " + this.dbms.getJdbcMetadataName(this.dbms.unreservedName("id")));
                    }
                } else if (debug) {
                    this.log("table not null:" + tableName + "Table has name " + table.getName());
                }
            }
            if (table != null) {
                if (debug) {
                    this.log("table not null now:" + tableName);
                }
                if (debug) {
                    this.log("columnsMetadata(m, tableName):" + this.columnsMetadata(m, tableName));
                }
                table.unifyWithDB(this.columnsMetadata(m, tableName));
                continue;
            }
            if (!debug) continue;
            this.log("table still null, probably doesn't have a troid:" + tableName);
        }
        Enumeration t2 = this.tables.elements();
        while (t2.hasMoreElements()) {
            table = (Table)t2.nextElement();
            ResultSet colDescs = this.columnsMetadata(m, this.dbms.unreservedName(table.getName()));
            if (colDescs.next()) continue;
            table.unifyWithDB(null);
        }
        t2 = this.tables.elements();
        while (t2.hasMoreElements()) {
            ((JdbcTable)t2.nextElement()).postInitialise();
        }
    }

    public void addConstraints() {
        this.inSession(AccessToken.root, new PoemTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws PoemException {
                PoemThread.commit();
                Database.this.beginStructuralModification();
                try {
                    Enumeration t = Database.this.tables.elements();
                    while (t.hasMoreElements()) {
                        ((Table)t.nextElement()).dbAddConstraints();
                    }
                    PoemThread.commit();
                }
                finally {
                    Database.this.endStructuralModification();
                }
            }

            public String toString() {
                return "Adding constraints to DB";
            }
        });
    }

    public final int transactionsMax() {
        return this.transactionsMax;
    }

    public final void setTransactionsMax(int t) {
        this.transactionsMax = t;
    }

    public int getTransactionsCount() {
        return this.transactions.size();
    }

    public int getFreeTransactionsCount() {
        return this.freeTransactions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PoemTransaction openTransaction() {
        Vector vector = this.freeTransactions;
        synchronized (vector) {
            if (this.freeTransactions.size() == 0) {
                throw new NoMoreTransactionsException("Database " + this.name + " has no free transactions remaining of " + this.transactions.size() + " transactions.");
            }
            PoemTransaction transaction = (PoemTransaction)this.freeTransactions.lastElement();
            this.freeTransactions.setSize(this.freeTransactions.size() - 1);
            return transaction;
        }
    }

    void notifyClosed(PoemTransaction transaction) {
        this.freeTransactions.addElement(transaction);
    }

    public PoemTransaction poemTransaction(int index) {
        return (PoemTransaction)this.transactions.elementAt(index);
    }

    public final Transaction transaction(int index) {
        return this.poemTransaction(index);
    }

    public boolean isFree(PoemTransaction trans) {
        return this.freeTransactions.contains(trans);
    }

    public void beginExclusiveLock() {
        if (PoemThread.inSession()) {
            this.lock.readLock().release();
        }
        try {
            this.lock.writeLock().acquire();
        }
        catch (InterruptedException e) {
            throw new InterruptedPoemException(e);
        }
    }

    public void endExclusiveLock() {
        this.lock.writeLock().release();
        if (PoemThread.inSession()) {
            try {
                this.lock.readLock().acquire();
            }
            catch (InterruptedException e) {
                throw new InterruptedPoemException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void perform(AccessToken accessToken, final PoemTask task, boolean useCommittedTransaction) throws PoemException {
        try {
            this.lock.readLock().acquire();
        }
        catch (InterruptedException e) {
            throw new InterruptedPoemException(e);
        }
        final PoemTransaction transaction = useCommittedTransaction ? null : this.openTransaction();
        try {
            PoemThread.inSession(new PoemTask(){

                public void run() throws PoemException {
                    task.run();
                    if (transaction != null) {
                        transaction.close(true);
                    }
                }

                public String toString() {
                    return task.toString();
                }
            }, accessToken, transaction);
        }
        finally {
            try {
                if (transaction != null && !this.isFree(transaction)) {
                    transaction.close(false);
                }
            }
            finally {
                this.lock.readLock().release();
            }
        }
    }

    public void inSession(AccessToken accessToken, PoemTask task) {
        this.perform(accessToken, task, false);
    }

    public void inSessionAsRoot(PoemTask task) {
        this.perform(AccessToken.root, task, false);
    }

    public void beginSession(AccessToken accessToken) {
        try {
            this.lock.readLock().acquire();
        }
        catch (InterruptedException e) {
            throw new InterruptedPoemException(e);
        }
        PoemTransaction transaction = this.openTransaction();
        try {
            PoemThread.beginSession(accessToken, transaction);
        }
        catch (AlreadyInSessionPoemException e) {
            this.notifyClosed(transaction);
            this.lock.readLock().release();
            throw e;
        }
    }

    public void endSession() {
        PoemTransaction tx = PoemThread.sessionToken().transaction;
        PoemThread.endSession();
        tx.close(true);
        this.lock.readLock().release();
    }

    public void inCommittedTransaction(AccessToken accessToken, PoemTask task) {
        this.perform(accessToken, task, true);
    }

    public final Table getTable(String name) throws NoSuchTablePoemException {
        Table table = this.getTableIgnoringCase(name);
        if (table == null) {
            throw new NoSuchTablePoemException(this, name);
        }
        return table;
    }

    private Table getTableIgnoringCase(String name) {
        Table table = (Table)this.tablesByName.get(name.toLowerCase());
        return table;
    }

    public final Enumeration tables() {
        return this.tables.elements();
    }

    public Enumeration getDisplayTables() {
        return this.getDisplayTables(PoemThread.inSession() ? PoemThread.transaction() : null);
    }

    public Enumeration getDisplayTables(PoemTransaction transaction) {
        Object[] displayTablesL = this.displayTables;
        if (displayTablesL == null) {
            Enumeration tableIDs = this.getTableInfoTable().troidSelection(null, this.quotedName("displayorder") + ", " + this.quotedName("name"), false, transaction);
            Vector<Table> them = new Vector<Table>();
            while (tableIDs.hasMoreElements()) {
                Table table = this.tableWithTableInfoID((Integer)tableIDs.nextElement());
                if (table == null) continue;
                them.addElement(table);
            }
            displayTablesL = new Table[them.size()];
            them.copyInto(displayTablesL);
            this.displayTables = displayTablesL;
        }
        return new ArrayEnumeration(this.displayTables);
    }

    Table tableWithTableInfoID(int tableInfoID) {
        Enumeration t = this.tables.elements();
        while (t.hasMoreElements()) {
            Table table = (Table)t.nextElement();
            Integer id = table.tableInfoID();
            if (id == null || id != tableInfoID) continue;
            return table;
        }
        return null;
    }

    public Enumeration columns() {
        return new FlattenedEnumeration(new MappedEnumeration(this.tables()){

            public Object mapped(Object table) {
                return ((Table)table).columns();
            }
        });
    }

    Column columnWithColumnInfoID(int columnInfoID) {
        Enumeration t = this.tables.elements();
        while (t.hasMoreElements()) {
            Column column = ((Table)t.nextElement()).columnWithColumnInfoID(columnInfoID);
            if (column == null) continue;
            return column;
        }
        return null;
    }

    public abstract TableInfoTable getTableInfoTable();

    public abstract TableCategoryTable getTableCategoryTable();

    public abstract ColumnInfoTable getColumnInfoTable();

    public abstract CapabilityTable getCapabilityTable();

    public abstract UserTable getUserTable();

    public abstract GroupTable getGroupTable();

    public abstract GroupMembershipTable getGroupMembershipTable();

    public abstract GroupCapabilityTable getGroupCapabilityTable();

    public abstract SettingTable getSettingTable();

    public ResultSet sqlQuery(String sql) throws SQLPoemException {
        SessionToken token = PoemThread.sessionToken();
        token.transaction.writeDown();
        try {
            Statement s = token.transaction.getConnection().createStatement();
            token.toTidy().add(s);
            ResultSet rs = s.executeQuery(sql);
            token.toTidy().add(rs);
            if (this.logSQL()) {
                this.log(new SQLLogEvent(sql));
            }
            this.incrementQueryCount(sql);
            return rs;
        }
        catch (SQLException e) {
            throw new ExecutingSQLPoemException(sql, e);
        }
    }

    public int sqlUpdate(String sql) throws SQLPoemException {
        SessionToken token = PoemThread.sessionToken();
        token.transaction.writeDown();
        try {
            Statement s = token.transaction.getConnection().createStatement();
            token.toTidy().add(s);
            int n = s.executeUpdate(sql);
            if (this.logSQL()) {
                this.log(new SQLLogEvent(sql));
            }
            this.incrementQueryCount(sql);
            return n;
        }
        catch (SQLException e) {
            throw this.dbms.exceptionForUpdate(null, sql, sql.indexOf("INSERT") >= 0 || sql.indexOf("insert") >= 0, e);
        }
    }

    public User guestUser() {
        if (this.guest == null) {
            this.guest = this.getUserTable().guestUser();
        }
        return this.guest;
    }

    public User administratorUser() {
        if (this.administrator == null) {
            this.administrator = this.getUserTable().administratorUser();
        }
        return this.administrator;
    }

    public String givesCapabilitySQL(User user, Capability capability) {
        return this.dbms.givesCapabilitySQL(user.troid(), capability.troid().toString());
    }

    private boolean dbGivesCapability(User user, Capability capability) {
        String sql = this.givesCapabilitySQL(user, capability);
        ResultSet rs = null;
        try {
            rs = this.sqlQuery(sql);
            boolean bl = rs.next();
            return bl;
        }
        catch (SQLPoemException e) {
            throw new UnexpectedExceptionPoemException(e);
        }
        catch (SQLException e) {
            throw new SQLSeriousPoemException(e, sql);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                System.err.println("Cannot close resultset after exception.");
            }
        }
    }

    public boolean hasCapability(User user, Capability capability) {
        if (capability == null) {
            return true;
        }
        return this.capabilityCache.hasCapability(user, capability);
    }

    public AccessToken guestAccessToken() {
        return this.getUserTable().guestUser();
    }

    public Capability administerCapability() {
        return this.getCapabilityTable().administer();
    }

    public Capability getCanAdminister() {
        return this.canAdminister;
    }

    public void setCanAdminister() {
        this.canAdminister = this.administerCapability();
    }

    public void setCanAdminister(String capabilityName) {
        this.canAdminister = this.getCapabilityTable().ensure(capabilityName);
    }

    public void trimCache(int maxSize) {
        Enumeration t = this.tables.elements();
        while (t.hasMoreElements()) {
            ((Table)t.nextElement()).trimCache(maxSize);
        }
    }

    public void uncache() {
        for (int t = 0; t < this.tables.size(); ++t) {
            ((Table)this.tables.elementAt(t)).uncache();
        }
    }

    public Enumeration referencesTo(final Persistent object) {
        return new FlattenedEnumeration(new MappedEnumeration(this.tables()){

            public Object mapped(Object table) {
                return ((Table)table).referencesTo(object);
            }
        });
    }

    public Enumeration referencesTo(final Table tableIn) {
        return new FlattenedEnumeration(new MappedEnumeration(this.tables()){

            public Object mapped(Object table) {
                return ((Table)table).referencesTo(tableIn);
            }
        });
    }

    public void dumpCacheAnalysis() {
        Enumeration t = this.tables.elements();
        while (t.hasMoreElements()) {
            ((Table)t.nextElement()).dumpCacheAnalysis();
        }
    }

    public void dump() {
        for (int t = 0; t < this.tables.size(); ++t) {
            System.out.println();
            ((Table)this.tables.elementAt(t)).dump();
        }
        System.err.println("there are " + this.getTransactionsCount() + " transactions " + "of which " + this.getFreeTransactionsCount() + " are free");
    }

    public Dbms getDbms() {
        return this.dbms;
    }

    private void setDbms(Dbms aDbms) {
        this.dbms = aDbms;
    }

    public final String quotedName(String name) {
        return this.getDbms().getQuotedName(name);
    }

    final SQLPoemType defaultPoemTypeOfColumnMetaData(ResultSet md) throws SQLException {
        return this.getDbms().defaultPoemTypeOfColumnMetaData(md);
    }

    public String toString() {
        if (this.connectionUrl == null) {
            return "unconnected database";
        }
        return this.connectionUrl;
    }

    public Connection getCommittedConnection() {
        return this.committedConnection;
    }

    public boolean logSQL() {
        return this.logSQL;
    }

    public void setLogSQL(boolean value) {
        this.logSQL = value;
    }

    public boolean logCommits() {
        return this.logCommits;
    }

    public void setLogCommits(boolean value) {
        this.logCommits = value;
    }

    void log(PoemLogEvent e) {
        System.err.println("---\n" + e.toString());
    }

    void log(String s) {
        System.err.println(s);
    }

    void beginStructuralModification() {
        this.beginExclusiveLock();
    }

    void endStructuralModification() {
        for (int t = 0; t < this.tables.size(); ++t) {
            ((Table)this.tables.elementAt(t)).uncache();
        }
        ++this.structureSerial;
        this.endExclusiveLock();
    }

    long structureSerial() {
        return this.structureSerial;
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public void incrementQueryCount(String sql) {
        this.lastQuery = sql;
        ++this.queryCount;
    }

    public String getLastQuery() {
        return this.lastQuery;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return StringUtils.capitalised(this.getName());
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    private class UserCapabilityCache {
        private Hashtable userCapabilities = null;
        private long groupMembershipSerial;
        private long groupCapabilitySerial;

        private UserCapabilityCache() {
        }

        boolean hasCapability(User user, Capability capability) {
            Long pair;
            Boolean known;
            PoemTransaction transaction = PoemThread.transaction();
            long currentGroupMembershipSerial = Database.this.getGroupMembershipTable().serial(transaction);
            long currentGroupCapabilitySerial = Database.this.getGroupCapabilityTable().serial(transaction);
            if (this.userCapabilities == null || this.groupMembershipSerial != currentGroupMembershipSerial || this.groupCapabilitySerial != currentGroupCapabilitySerial) {
                this.userCapabilities = new Hashtable();
                this.groupMembershipSerial = currentGroupMembershipSerial;
                this.groupCapabilitySerial = currentGroupCapabilitySerial;
            }
            if ((known = (Boolean)this.userCapabilities.get(pair = new Long(user.troid().longValue() << 32 | capability.troid().longValue()))) != null) {
                return known;
            }
            boolean does = Database.this.dbGivesCapability(user, capability);
            this.userCapabilities.put(pair, does ? Boolean.TRUE : Boolean.FALSE);
            return does;
        }
    }

    public class ConnectingException
    extends PoemException {
        private static final long serialVersionUID = 1L;

        public String getMessage() {
            return "Connection to the database is currently in progress; please try again in a moment";
        }
    }
}

