/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.melati.poem.AccessPoemException;
import org.melati.poem.ColumnInfo;
import org.melati.poem.DoublePoemType;
import org.melati.poem.FixedPointAtomPoemType;
import org.melati.poem.ParsingPoemException;
import org.melati.poem.PoemTypeFactory;
import org.melati.poem.SQLPoemType;
import org.melati.poem.SQLSeriousPoemException;
import org.melati.poem.TypeMismatchPoemException;
import org.melati.poem.dbms.Dbms;

public class BigDecimalPoemType
extends FixedPointAtomPoemType {
    public BigDecimalPoemType(boolean nullable) {
        super(3, "DECIMAL", nullable, 22, 2);
    }

    public BigDecimalPoemType(boolean nullable, int precision, int scale) {
        super(3, "DECIMAL", nullable, precision, scale);
    }

    protected void _assertValidRaw(Object raw) {
        if (raw != null && !(raw instanceof BigDecimal)) {
            throw new TypeMismatchPoemException(raw, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _getRaw(ResultSet rs, int col) throws SQLException {
        ResultSet resultSet = rs;
        synchronized (resultSet) {
            BigDecimal x = rs.getBigDecimal(col);
            return rs.wasNull() ? null : x;
        }
    }

    protected void _setRaw(PreparedStatement ps, int col, Object real) throws SQLException {
        ps.setBigDecimal(col, (BigDecimal)real);
    }

    protected Object _rawOfString(String rawString) throws ParsingPoemException {
        try {
            return new BigDecimal(rawString);
        }
        catch (NumberFormatException e) {
            throw new ParsingPoemException(this, rawString, e);
        }
    }

    protected String _sqlDefinition(Dbms dbms) {
        try {
            return dbms.getFixedPtSqlDefinition(this.getScale(), this.getPrecision());
        }
        catch (SQLException e) {
            throw new SQLSeriousPoemException(e);
        }
    }

    protected boolean _canRepresent(SQLPoemType other) {
        return other instanceof BigDecimalPoemType || other instanceof DoublePoemType;
    }

    public String toDsdType() {
        return "BigDecimal";
    }

    protected void _saveColumnInfo(ColumnInfo columnInfo) throws AccessPoemException {
        columnInfo.setTypefactory(PoemTypeFactory.BIGDECIMAL);
        columnInfo.setPrecision(this.getPrecision());
        columnInfo.setScale(this.getScale());
    }
}

